
TTJ_MD_83 = {

	Name 			= 'TTJ_MD_83',
	DisplayName		= _('MD-83 (TTJ)'),
	date_of_introduction	= 1980,
	country_of_origin	= "USA",
	Picture 		= "TTJ_DC-9.png",
	Rate 			= "40", -- RewardPoint in Multiplayer
	Shape			= "TTJ_MD_83",
	WorldID			=  WSTYPE_PLACEHOLDER,
	singleInFlight 	= true,

	shape_table_data 	= {
		{
			file  	 	= 'ttj_md_83';
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt		= 'kc-135-oblomok'; -- Name of destroyed object file name
			fire		= { 300, 2}; 		-- Fire on the ground after destoyed: 300sec 2m
			username	= 'TTJ_MD_83';
			index		=  WSTYPE_PLACEHOLDER;
			classname	= "lLandPlane";
			positioning	= "BYNORMAL";
		},
		{
			name  		= "kc-135-oblomok";
			file  		= "kc-135-oblomok";
			fire  		= { 240, 2};
		},
	},

	mapclasskey 		= "P0091000029",
	attribute		= {
		wsType_Air, wsType_Airplane, wsType_Cruiser, WSTYPE_PLACEHOLDER,
		"Transports",
	},

	Categories = {
	},

	M_empty		=	36000,		-- kg  (25789 at -30)
	M_nominal	=	60000,		-- kg  (40000 at -30)
	M_max		=	72600,		-- kg  (48980 at -30)
	M_fuel_max	=	15580,		-- kg  (11180 at -30)
	H_max		=	11000,		-- max altitude/ceiling (meters)
	average_fuel_consumption	=	0.500,    --   (0.600 at -30)
	CAS_min		=	75,		     --    (54 at -30)
	V_opt		=	220,		-- m/s = 792 km/h = 428 knots    (220 at -30)
	V_take_off	=	72,		-- m/s = 260 km/h = 140 knots    (70 at -30)
	V_land		=	71,		-- m/s = 254 km/h = 137 knots    (66 at -30)
	has_afteburner	=	false,
	has_speedbrake	=	true,
	has_thrustReverser	=	true,
	has_differential_stabilizer =	false,
	radar_can_see_ground	=	true,
	main_gear_pos = 	{-2.099,	-2.383,	2.554},
	main_gear_wheel_diameter	=	1.1303,
	nose_gear_pos = 	{20.018,	-2.015,	0},
	nose_gear_wheel_diameter	=	0.6528,
	tand_gear_max	=	3.73,
	AOA_take_off	=	0.14,
	stores_number	=	0,
	bank_angle_max	=	45,
	Ny_min	=	0.5,
	Ny_max	=	2.5,
	V_max_sea_level	=	200,
	V_max_h	=	260,
	tanker_type	=	0,
	wing_area	=	112.3,    --  (93.0 at -30)
	wing_span	=	32.82,   --  (28.47 at -30)
	thrust_sum_max	=	20270,   --  (15040 at -30)
	thrust_sum_ab	=	20270,   --  (15040 at -30)
	Vy_max	=	10,
	length		=	45.04,  --  (36.37 at -30)
	height		=	9.02,  --  (8.38 at -30)
	flaps_maneuver	=	0.5,
	Mach_max	=	0.9,
	range		=	4720,  --  (2800 at -30)
	crew_size	=	2,
	RCS	=	60,
	Ny_max_e	=	2,
	detection_range_max	=	0,
	IR_emission_coeff	=	4,
	IR_emission_coeff_ab	=	0,
	engines_count	=	2,
	wing_tip_pos = 	{-6.49, 0.5, 16.23},
	engines_nozzles = {
		{
			pos = 	{-14.48, 0.60, -2.7},
			elevation	=	0,
			diameter	=	1.0,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level 	= 	0.12,
		}, 	
		{
			pos = 	{-14.48, 0.60, 2.7},
			elevation	=	0,
			diameter	=	1.0,
			exhaust_length_ab	=	11.794,
			exhaust_length_ab_K	=	0.76,
			smokiness_level 	= 	0.12,
		},
	}, -- end of engines_nozzles
	crew_members = {
		[1] = 
		{
			ejection_seat_name	=	0,
			drop_canopy_name	=	0,
			pos = 	{18.5, -2.01, 9.0},
		}, -- end of [1]
		[2] = 
		{
			ejection_seat_name	=	0,
			drop_canopy_name	=	0,
			pos = 	{20.0, -2.01, 10.0},
		}, -- end of [2]
	}, -- end of crew_members
	brakeshute_name	=	0,
	is_tanker	=	false,
--	air_refuel_receptacle_pos = 	{6.731,	0.825,	0.492},
	fires_pos = {
		[1] = 	{-0.88,	-0.88,	0},
		[2] = 	{-1.8,	0,	6.0},
		[3] = 	{-1.8,	0,	-6.0},
		[4] = 	{-0.26,	-0.09,	2.77},
		[5] = 	{-0.26,	-0.09,	-2.77},
		[6] = 	{-11.97,	0.58,	2.74},
		[7] = 	{-11.97,	0.58,	-2.74},
		[8] = 	{-3.4,	0.19,	9.85},
		[9] = 	{-3.4,	0.19,	-9.85},
		[10] = 	{-5.85,	0.3,	14.78},
		[11] = 	{-5.85,	0.3,	-14.78},
	}, -- end of fires_pos

	CanopyGeometry = {
		azimuth = {-110.0, 110.0},
		elevation = {-40.0, 70.0}
	},

	Failures = {
		{ id = 'asc',		label = _('ASC'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'autopilot',	label = _('AUTOPILOT'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'hydro',		label = _('HYDRO'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'l_engine',	label = _('L-ENGINE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'r_engine',	label = _('R-ENGINE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},
	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Pylons = {
	},

	Tasks = {
		aircraft_task(Transport),
	},
	DefaultTask = aircraft_task(Nothing),

	SFM_Data = {     --edited from kc-135
		aerodynamics = {
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.015,
			cx_flap	=	0.05,
			cy_flap	=	1,
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,	0.023,	0.117,	0.064,	0,	0.5,	20,	1.4},
				[2] = 	{0.2,	0.023,	0.117,	0.064,	0,	1.5,	20,	1.4},
				[3] = 	{0.4,	0.023,	0.117,	0.064,	0,	2.5,	20,	1.4},
				[4] = 	{0.6,	0.025,	0.117,	0.064,	0.022,	3.5,	20,	1.4},
				[5] = 	{0.7,	0.03,	0.117,	0.083,	0.031,	3.5,	20,	1.2},
				[6] = 	{0.8,	0.032,	0.117,	0.107,	0.04,	3.5,	20,	1},
				[7] = 	{0.9,	0.045,	0.117,	0.148,	0.058,	3.5,	20,	0.8},
				[8] = 	{1,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.7},
				[9] = 	{1.5,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.2},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = {
			Nmg	=	65.9,	-- RPM at idle
			MinRUD	=	0,	-- Min state of the throttle
			MaxRUD	=	1,	-- Max state of the throttle
			MaksRUD	=	1,	-- Military power state of the throttle
			ForsRUD	=	1,	-- Afterburner state of the throttle
			typeng	=	4,
			--[[
				E_TURBOJET    = 0
				E_TURBOJET_AB = 1
				E_PISTON      = 2
				E_TURBOPROP   = 3
				E_TURBOFAN    = 4
				E_TURBOSHAFT  = 5
			--]]
			hMaxEng	=	14.3,	-- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085,	-- Engine drag coeficient
						-- Affects drag of engine when shutdown
						-- cemax/cefor affect sponginess of elevator/inertia at slow speed
						-- affects available g load apparently
			cemax	=	1.24,	-- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in );  fuel consumption for a single engine in dry configuration. Units are in kg / sec.
			cefor	=	2.56,	-- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in );  fuel consumption for a single engine in afterburner configuration. Units are in kg / sec.
			dpdh_m	=	9000,	--  altitude coefficient for max thrust
			dpdh_f	=	9000,	--  altitude coefficient for AB thrust
			table_data = {
				--	 M	Pmax		Pmax_ab
				[1] = 	{0,	419622,		419622},
				[2] = 	{0.2,	351283,		351283},
				[3] = 	{0.4,	313369,		313369},
				[4] = 	{0.6,	281920,		281920},
				[5] = 	{0.7,	284166,		284166},
				[6] = 	{0.8,	294275,		294275},
				[7] = 	{0.9,	307753,		307753},
				[8] = 	{1,	313370,		313370},
				[9] = 	{1.1,	314492,		314492},
				[10] = 	{1.2,	298768,		298768},
				[11] = 	{1.3,	106703,		106703},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua , from Yak-40 values
	Damage = {
		[1]  = {critical_damage = 5, args = {296}},
		[2]  = {critical_damage = 5, args = {297}},
		[3]  = {critical_damage = 15, args = {65}},
		[9]  = {critical_damage = 6, args = {154}},
		[10] = {critical_damage = 6, args = {153}},
		[11] = {critical_damage = 6, args = {167}},
		[12] = {critical_damage = 6, args = {161}},
--		[17] = {critical_damage = 6, args = {168}}, -- Yak-40's center engine
		[23] = {critical_damage = 6, args = {223}}, 
		[29] = {critical_damage = 8, args = {224}, deps_cells = {23}},
		[35] = {critical_damage = 20, args = {225}, deps_cells = {23, 29}},
		[24] = {critical_damage = 6, args = {213}},
		[30] = {critical_damage = 8, args = {214}, deps_cells = {24}},
		[36] = {critical_damage = 20, args = {215}, deps_cells = {24, 30}},
		[39] = {critical_damage = 6, args = {244}},
		[40] = {critical_damage = 6, args = {241}},
		[51] = {critical_damage = 6, args = {240}},
		[52] = {critical_damage = 6, args = {238}},
		[53] = {critical_damage = 6, args = {248}},
		[55] = {critical_damage = 20, args = {156, 159}},
		[56] = {critical_damage = 6, args = {158}},
		[57] = {critical_damage = 6, args = {157}},
		[82] = {critical_damage = 6, args = {152}},
	},

	DamageParts = {
--		[1] = "kc-135-oblomok-wing-r", -- wing R
--		[2] = "kc-135-oblomok-wing-l", -- wing L
--		[3] = "kc-135-oblomok-noise", -- nose
--		[4] = "kc-135-oblomok-tail-r", -- tail
--		[5] = "kc-135-oblomok-tail-l", -- tail
	},

-- DCS World\Scripts\Aircrafts\_Common\Lights.lua 2.7.16
--	WOLALIGHT_STROBES	   = 1
--	WOLALIGHT_SPOTS		   = 2   : yak-40
--	WOLALIGHT_LANDING_LIGHTS   = 2
--	WOLALIGHT_NAVLIGHTS	   = 3   : yak-40
--	WOLALIGHT_FORMATION_LIGHTS = 4
--	WOLALIGHT_TIPS_LIGHTS      = 5
--	WOLALIGHT_TAXI_LIGHTS      = 6   : yak-40
--	WOLALIGHT_BEACONS	   = 7   : yak-40
--	WOLALIGHT_CABIN_BOARDING   = 8   : yak-40
--	WOLALIGHT_CABIN_NIGHT      = 9   : yak-40
--	WOLALIGHT_REFUEL_LIGHTS    = 10
--	WOLALIGHT_PROJECTORS       = 11
--	WOLALIGHT_AUX_LIGHTS       = 12
--	WOLALIGHT_IR_FORMATION     = 13


	lights_data = { typename = "collection", lights = {

		[WOLALIGHT_STROBES] = { typename = "collection",
			lights = {
				{typename  = "strobelight", connector =  "RED_BEACON"   ,argument =  83, 
					proto = lamp_prototypes.MSL_3_2, emitter_shift_x = -0.25,},
				{typename  = "strobelight", connector =  "RED_BEACON_2" ,argument =  83, 
					proto = lamp_prototypes.MSL_3_2, emitter_shift_x = -0.25,},
				{
					typename = "Spot", connector = "BANO_1",
					controller = "VariablePatternStrobe", mode = "2 Flash Long",
					proto = lamp_prototypes.MPS_1, intensity_max = 400.0, period = 0.333, phase_shift = 0.25,
					direction = {azimuth = math.rad(-90.0), elevation = math.rad(0)}, angle_max = math.rad(180.0), angle_min = math.rad(0),
				},
				{
					typename = "Spot", connector = "BANO_2",
					controller = "VariablePatternStrobe", mode = "2 Flash Long",
					proto = lamp_prototypes.MPS_1, intensity_max = 400.0, period = 0.333, phase_shift = 0.25,
					direction = {azimuth = math.rad(90.0), elevation = math.rad(0)}, angle_max = math.rad(180.0), angle_min = math.rad(0),
				},
			},
		},
		[WOLALIGHT_BEACONS] = { typename = "collection",
			lights = {
				{typename  = "strobelight", connector =  "RED_BEACON"   ,argument =  83, 
					proto = lamp_prototypes.MSL_3_2, emitter_shift_x = -0.25,},
				{typename  = "strobelight", connector =  "RED_BEACON_2" ,argument =  83, 
					proto = lamp_prototypes.MSL_3_2, emitter_shift_x = -0.25,},
			},
		},
		[WOLALIGHT_NAVLIGHTS] = { typename = "collection",
			lights = {
--	backup					{typename  = "omnilight",connector =  "BANO_1"  ,argument  =  190,color = {0.99, 0.11, 0.3}}, -- Left Position(red)
--	backup					{typename  = "omnilight",connector =  "BANO_2"  ,argument  =  191,color = {0, 0.894, 0.6}}, -- Right Position(green)
--	backup					{typename  = "omnilight",connector =  "BANO_0"  ,argument  =  192,color = {1, 1, 1}}, -- Tail Position white)
				{
					typename = "Spot", connector = "BANO_0", dir_correction = {azimuth = math.rad(180.0)}, argument = 192,
					proto = lamp_prototypes.HS_2A, angle_max = math.rad(180.0), angle_min = math.rad(170.0),
				},
				{
					typename = "Spot", connector = "BANO_00", dir_correction = {azimuth = math.rad(180.0)},
					proto = lamp_prototypes.HS_2A, angle_max = math.rad(180.0), angle_min = math.rad(170.0),
				},
				{
					typename = "Spot", connector = "BANO_1", dir_correction = {azimuth = math.rad(-45.0), elevation = math.rad(45.0)}, argument = 190,
					proto = lamp_prototypes.BANO_7M_red,
				},
				{
					typename = "Spot", connector = "BANO_2", dir_correction = {azimuth = math.rad(45.0), elevation = math.rad(45.0)}, argument = 191,
					proto = lamp_prototypes.BANO_7M_green,
				},
				{typename = "argumentlight", argument = 68,},		-- Logo Lights ON
			},
		},
		[WOLALIGHT_FORMATION_LIGHTS] = { typename = "collection", -- Nav Lights always ON in flights gimick
			lights = {
				{typename = "argumentlight", argument = 192,},
				{typename = "argumentlight", argument = 190,},
				{typename = "argumentlight", argument = 191,},
				{typename  = "strobelight", connector =  "RED_BEACON"   ,argument =  83, 
					proto = lamp_prototypes.MSL_3_2, emitter_shift_x = -0.25,},
				{typename  = "strobelight", connector =  "RED_BEACON_2" ,argument =  83, 
					proto = lamp_prototypes.MSL_3_2, emitter_shift_x = -0.25,},
			},
		},
		[WOLALIGHT_SPOTS] = { typename = "collection",	-- Landing Lights
			lights = {
				{
					typename = "Spot", connector = "RESERV2_SPOT_PTR", dir_correction = {azimuth = math.rad(-2.0), elevation = math.rad(4.5)},
					proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(21.0), angle_min = math.rad(0),
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
				{
					typename = "Omni", connector = "RESERV2_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
				},
				{
					typename = "Spot", connector = "RESERV1_SPOT_PTR", dir_correction = {azimuth = math.rad(2.0), elevation = math.rad(4.5)},
					proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(21.0), angle_min = math.rad(0),
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
				{
					typename = "Omni", connector = "RESERV1_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
				},
				{
					typename = "Spot", connector = "MAIN1_SPOT_PTR", dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(4.0)}, argument = 208,
					proto = lamp_prototypes.LFS_R_27_180, angle_max = math.rad(21.0), angle_min = math.rad(0), movable = true,
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
				{
					typename = "Omni", connector = "MAIN1_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_R_27_180, range = 6.0,
				},
				{
					typename = "Spot", connector = "GRD_FLL1_PTR", dir_correction = {azimuth = math.rad(-45.0), elevation = math.rad(6.0)},
					proto = lamp_prototypes.LFS_R_27_180, angle_max = math.rad(75), angle_min = math.rad(0),
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
				{
					typename = "Spot", connector = "GRD_FLL2_PTR", dir_correction = {azimuth = math.rad(45.0), elevation = math.rad(6.0)},
					proto = lamp_prototypes.LFS_R_27_180, angle_max = math.rad(75), angle_min = math.rad(0),
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
			},
		},
		[WOLALIGHT_TAXI_LIGHTS] = { typename = "collection",
			lights = {
				{
					typename = "Spot", connector = "MAIN2_SPOT_PTR", argument = 209, dir_correction = {azimuth = math.rad(0.0), elevation = math.rad(2.0)},
					proto = lamp_prototypes.LFS_R_27_180, angle_max = math.rad(45), angle_min = math.rad(0), movable = true,
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
				{
					typename = "Omni", connector = "MAIN2_SPOT_PTR", pos_correction = {0.3, 0.0, 0.0},
					proto = lamp_prototypes.LFS_R_27_180, range = 6.0,
				},
				{
					typename = "Spot", connector = "GRD_FLL1_PTR", dir_correction = {azimuth = math.rad(-45.0), elevation = math.rad(6.0)},
					proto = lamp_prototypes.LFS_R_27_180, angle_max = math.rad(75), angle_min = math.rad(0),
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
				{
					typename = "Spot", connector = "GRD_FLL2_PTR", dir_correction = {azimuth = math.rad(45.0), elevation = math.rad(6.0)},
					proto = lamp_prototypes.LFS_R_27_180, angle_max = math.rad(75), angle_min = math.rad(0),
					cool_down_t = 0.8, exposure = {{0, 0.9, 1.0}},
				},
			},
		},
		[WOLALIGHT_CABIN_NIGHT] = { typename = "collection",
			lights = {
				{typename = "argumentlight", argument = 69,},
			},
		},
--[[		backup old codes
	[5] = { typename = "collection", -- WOLALIGHT_TIPS_LIGHTS
					lights = {	
						--{typename  = "natostrobelight",	argument_1  = 199, period = 1.2, color = {0.8,0,0}, connector = "RESERV_BANO_1"}, --R
						--{typename  = "natostrobelight",	argument_1  = 199, period = 1.2, color = {0.8,0,0}, connector = "RESERV1_BANO_1"}, --L
						--{typename  = "natostrobelight",	argument_1  = 199, period = 1.2, color = {0.8,0,0}, connector = "RESERV2_BANO_1"}, --H
						--{typename  = "natostrobelight",	argument_1  = 195, period = 1.2, color = {0.8,0,0}, connector = "WHITE_BEACON L"}, --195
						--{typename  = "natostrobelight",	argument_1  = 196, period = 1.2, color = {0.8,0,0}, connector = "WHITE_BEACON R"}, --196
						--{typename  = "natostrobelight",	argument_1  = 192, period = 1.2, color = {0.8,0,0}, connector = "BANO_0_BACK"},
						--{typename  = "natostrobelight",	argument_1  = 195, period = 1.2, color = {0.8,0,0}, connector = "RED_BEACON L"},
						--{typename  = "natostrobelight",	argument_1  = 196, period = 1.2, color = {0.8,0,0}, connector = "RED_BEACON R"},
							}
			},
--]]
	}},
}

add_aircraft(TTJ_MD_83)
